///////////////
// Card View //
///////////////

#pragma once

#include "View List.h"
#include "Card Details.h"
#include <iostream.h>

class CardView : public ViewItem
{
    public:

        void Create (int);
        void Create (int, int x, int y);
        void Create (int, const RECT&);

        char Sort ();
        void Hide ();
        void Delete (HWND confirm);
        void Drop (int);
        void Rename (HWND);
        void ModifyCard (int);
        void DeleteCard (int);

        void Load (istream&);
        void LoadData (istream&);
        void Save (ostream&);
        void SaveData (ostream&);

        HMENU GetMenu ();
        int GetCard ();

    private:

        void Modify ();
        void Delete ();
        void SetTitle ();

        void OnCommand (int, int, HWND);
        int OnCreate (CREATESTRUCT *);
        void OnDestroy ();
        BOOL OnEraseBkgnd (HDC);
        void OnLButtonDblClk (int, int, int);
        void OnSize (int, int, int);

        epp_Menu Menu;
        epp_Menu ViewMenu;
        CardDetails Card;

    DECLARE_HANDLER
};

CardView * AllocCardView ();